/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.toolkit.util.WcmEncodingUtil;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IDMUtilities;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.trident.VWIDMTridentAttachment;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentStoredSearch;
import java.io.Serializable;

class VWIDMStoredSearchAttachment
extends VWIDMTridentAttachment
implements Serializable,
IVWIDMAttachment {
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWIDMStoredSearchAttachment";
    private static final String s_openTitle = new VWString("idm.trident.srchAtt.openTitle", "Stored Search").toString();
    private static final int m_width = 700;
    private static final int m_height = 500;
    private VWIDMTridentStoredSearch m_srchItem = null;

    private void initSrch(IVWIDMItem item) throws VWException {
        String m_method = "initSrch";
        try {
            this.m_item = item;
            this.m_srchItem = (VWIDMTridentStoredSearch)item;
            this.m_id = this.m_srchItem.getVersionSeriesId();
            this.m_lib = item.getLibraryId();
            this.m_libName = item.getLibraryLabel();
            this.m_libType = item.getLibraryType();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.att.initSrch", "Unable to initialize the stored search attachment object.");
        }
    }

    public VWIDMStoredSearchAttachment(String id, String version, String lib, int libType) throws VWException {
        this.initSrch(VWIDMTridentItem.getItem(4, lib, id, version));
    }

    public VWIDMStoredSearchAttachment(IVWIDMItem item) throws VWException {
        this.initSrch(item);
    }

    public void open() throws VWException {
        String m_method = "open";
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append("objectStoreName=").append(WcmEncodingUtil.encodeLabel((String)this.m_libName)).append("&objectType=storedsearch");
        String m_version = this.m_srchItem.getVersionId();
        if (m_version != null) {
            urlBuf.append("&id=").append(IDMUtilities.URLEncoder(m_version));
        }
        urlBuf.append("&vsId=").append(IDMUtilities.URLEncoder(this.m_id));
        String url = this.getBaseURL() + "WcmObjectBookmark.jsp?" + urlBuf.toString();
        logger.fine(m_className, m_method, url);
        IDMUtilities.openWindow(url, s_openTitle, "yes", 700, 500);
    }
}

